<?php
/**
 * Test Daily Rebate Payout Cron Job
 * This script allows you to test the cron job manually
 */

require_once("../../conn.php");
require_once("rebate_functions.php");

echo "<h2>Test Daily Rebate Payout Cron Job</h2>";

// Check if this is a test run
$testRun = isset($_GET['test']) && $_GET['test'] == '1';
$specificDate = isset($_GET['date']) ? $_GET['date'] : date('Y-m-d', strtotime('-1 day'));

if ($testRun) {
    echo "<div style='background: #fff3cd; padding: 10px; border-radius: 5px; margin: 10px 0;'>";
    echo "<strong>⚠️ TEST MODE:</strong> This is a test run. No actual payments will be made.";
    echo "</div>";
}

echo "<h3>Configuration</h3>";
echo "<ul>";
echo "<li><strong>Processing Date:</strong> $specificDate</li>";
echo "<li><strong>Current Time:</strong> " . date('Y-m-d H:i:s') . "</li>";
echo "<li><strong>Mode:</strong> " . ($testRun ? "Test (No actual payments)" : "Live (Actual payments)") . "</li>";
echo "</ul>";

// Check if bet_rebates table exists
$tableCheck = $conn->query("SHOW TABLES LIKE 'bet_rebates'");
if ($tableCheck->num_rows == 0) {
    echo "<div style='background: #f8d7da; padding: 10px; border-radius: 5px; color: #721c24;'>";
    echo "<strong>ERROR:</strong> bet_rebates table does not exist. Please create it first.";
    echo "</div>";
    exit;
}

// Get users with rebates for the specified date
$usersQuery = "SELECT DISTINCT br.user_id, 
                      SUM(br.rebate_amount) as total_rebate,
                      COUNT(*) as bet_count,
                      br.vip_level,
                      ss.username,
                      sk.motta as current_balance
               FROM bet_rebates br
               LEFT JOIN shonu_subjects ss ON br.user_id = ss.id
               LEFT JOIN shonu_kaichila sk ON br.user_id = sk.balakedara
               WHERE DATE(br.created_at) = '$specificDate'
               AND (br.is_paid IS NULL OR br.is_paid = 0)
               GROUP BY br.user_id
               HAVING total_rebate > 0
               ORDER BY total_rebate DESC";

$usersResult = $conn->query($usersQuery);

if (!$usersResult) {
    echo "<div style='background: #f8d7da; padding: 10px; border-radius: 5px; color: #721c24;'>";
    echo "<strong>ERROR:</strong> Failed to fetch users with rebates: " . $conn->error;
    echo "</div>";
    exit;
}

$totalUsers = $usersResult->num_rows;
$totalRebateAmount = 0;

echo "<h3>Users with Rebates for $specificDate</h3>";

if ($totalUsers > 0) {
    echo "<p><strong>Found $totalUsers users with unpaid rebates</strong></p>";
    
    echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr style='background: #f2f2f2;'>";
    echo "<th>User ID</th>";
    echo "<th>Username</th>";
    echo "<th>VIP Level</th>";
    echo "<th>Bet Count</th>";
    echo "<th>Current Balance</th>";
    echo "<th>Rebate Amount</th>";
    echo "<th>New Balance</th>";
    echo "<th>Status</th>";
    echo "</tr>";
    
    while ($userRow = $usersResult->fetch_assoc()) {
        $userId = $userRow['user_id'];
        $username = $userRow['username'] ?? 'Unknown';
        $vipLevel = $userRow['vip_level'] ?? 0;
        $betCount = $userRow['bet_count'];
        $currentBalance = $userRow['current_balance'] ?? 0;
        $userRebateAmount = $userRow['total_rebate'];
        $newBalance = $currentBalance + $userRebateAmount;
        
        $totalRebateAmount += $userRebateAmount;
        
        echo "<tr>";
        echo "<td>$userId</td>";
        echo "<td>$username</td>";
        echo "<td>$vipLevel</td>";
        echo "<td>$betCount</td>";
        echo "<td>₹" . number_format($currentBalance, 2) . "</td>";
        echo "<td>₹" . number_format($userRebateAmount, 2) . "</td>";
        echo "<td>₹" . number_format($newBalance, 2) . "</td>";
        
        if ($testRun) {
            echo "<td style='color: #856404;'>Test Mode</td>";
        } else {
            // Actually process the payment
            $conn->begin_transaction();
            
            try {
                // Update user balance
                $updateQuery = "UPDATE shonu_kaichila 
                               SET motta = '$newBalance' 
                               WHERE balakedara = '$userId'";
                
                if ($conn->query($updateQuery)) {
                    // Mark rebates as paid
                    $markPaidQuery = "UPDATE bet_rebates 
                                     SET is_paid = 1, paid_at = NOW() 
                                     WHERE user_id = '$userId' 
                                     AND DATE(created_at) = '$specificDate'
                                     AND (is_paid IS NULL OR is_paid = 0)";
                    
                    if ($conn->query($markPaidQuery)) {
                        $conn->commit();
                        echo "<td style='color: #155724;'>✓ Paid</td>";
                    } else {
                        $conn->rollback();
                        echo "<td style='color: #721c24;'>✗ Failed to mark as paid</td>";
                    }
                } else {
                    $conn->rollback();
                    echo "<td style='color: #721c24;'>✗ Failed to update balance</td>";
                }
                
            } catch (Exception $e) {
                $conn->rollback();
                echo "<td style='color: #721c24;'>✗ Error: " . $e->getMessage() . "</td>";
            }
        }
        
        echo "</tr>";
    }
    
    echo "</table>";
    
    echo "<h3>Summary</h3>";
    echo "<ul>";
    echo "<li><strong>Total Users:</strong> $totalUsers</li>";
    echo "<li><strong>Total Rebate Amount:</strong> ₹" . number_format($totalRebateAmount, 2) . "</li>";
    echo "<li><strong>Mode:</strong> " . ($testRun ? "Test Run (No actual payments)" : "Live Run (Payments processed)") . "</li>";
    echo "</ul>";
    
} else {
    echo "<p><strong>No users found with unpaid rebates for $specificDate</strong></p>";
}

// Add is_paid and paid_at columns if they don't exist
$alterTableQuery = "ALTER TABLE bet_rebates 
                   ADD COLUMN is_paid TINYINT(1) DEFAULT 0,
                   ADD COLUMN paid_at TIMESTAMP NULL DEFAULT NULL";

if (@$conn->query($alterTableQuery)) {
    echo "<p style='color: green;'>✓ Added is_paid and paid_at columns to bet_rebates table</p>";
} else {
    echo "<p style='color: #856404;'>ℹ️ Columns is_paid and paid_at already exist in bet_rebates table</p>";
}

echo "<h3>Test Options</h3>";
echo "<ul>";
echo "<li><a href='?test=1&date=$specificDate'>Test Mode (No actual payments)</a></li>";
echo "<li><a href='?test=0&date=$specificDate'>Live Mode (Process actual payments)</a></li>";
echo "<li><a href='?test=1&date=" . date('Y-m-d', strtotime('-2 days')) . "'>Test for 2 days ago</a></li>";
echo "<li><a href='?test=1&date=" . date('Y-m-d') . "'>Test for today</a></li>";
echo "</ul>";

echo "<h3>Manual Cron Execution</h3>";
echo "<p>To run the actual cron job manually, execute:</p>";
echo "<div style='background: #f0f0f0; padding: 10px; border-radius: 5px; font-family: monospace;'>";
echo "php " . __DIR__ . "/daily_rebate_payout_cron.php";
echo "</div>";

$conn->close();
?>
